import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define the diagram
fig, ax = plt.subplots(figsize=(14, 5))

# Colors for statuses
clear_color = 'limegreen'
not_clear_color = 'crimson'

# Curb positions
curb_positions = [0, 1, 2, 3, 4, 5, 6]

# Define curbs and cars
curbs = {
    0: {'cars': ['car6', 'car7'], 'status': 'occupied'},
    1: {'cars': ['car1', 'car8'], 'status': 'occupied'},
    2: {'cars': ['car9', 'car4'], 'status': 'occupied'},
    3: {'cars': ['car3'], 'status': 'clear'},
    4: {'cars': ['car0'], 'status': 'clear'},
    5: {'cars': ['car5'], 'status': 'clear'},
    6: {'cars': ['car2'], 'status': 'clear'}
}

# Draw curbs and cars
for i, position in enumerate(curb_positions):
    # Determine curb color based on status
    curb_color = not_clear_color if curbs[position]['status'] == 'occupied' else clear_color
    # Draw curb
    curb_rect = patches.Rectangle((i * 1.8, 0), 1.5, 2, linewidth=1, edgecolor='black', facecolor=curb_color)
    ax.add_patch(curb_rect)
    ax.text(i * 1.8 + 0.75, 1.8, f'curb_{position}\n({curbs[position]["status"]})', ha='center', va='center', color='black', fontsize=10)
    
    # Draw cars
    for j, car in enumerate(curbs[position]['cars']):
        car_color = clear_color if j == 1 else not_clear_color
        car_circle = patches.Circle((i * 1.8 + 0.75, 1 - 0.5 * j), 0.2, linewidth=1, edgecolor='black', facecolor=car_color)
        ax.add_patch(car_circle)
        ax.text(i * 1.8 + 0.75, 1 - 0.5 * j, f'{car}\n(clear)' if j == 1 else f'{car}\n(not clear)', ha='center', va='center', color='white', fontsize=8)

# Create legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear'),
    patches.Patch(facecolor=not_clear_color, edgecolor='black', label='Not Clear')
]
ax.legend(handles=legend_elements, loc='upper left')

# Set limits and remove axes
ax.set_xlim(-0.5, 13)
ax.set_ylim(-1, 3)
ax.axis('off')

# Save the figure
plt.savefig('parking/one_shot/ini_diagram_code/attempts/attempt_25.png')
plt.show()